/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.client.screen;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.client.ActiveChallengesOverlay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class ChallengesScreen
extends class_437 {
    private final class_437 parent;
    private float scrollPosition = 0.0f;
    private boolean isDragging = false;
    private static final int ENTRY_HEIGHT = 32;
    private static final int CATEGORY_HEIGHT = 24;
    private static final int CATEGORY_SPACING = 10;
    private static final int CHALLENGE_SPACING = 6;
    private static final int HEADER_HEIGHT = 70;
    private static final int FOOTER_HEIGHT = 32;
    private static final int SCROLLBAR_WIDTH = 6;
    private final List<MenuEntry> menuEntries = new ArrayList<MenuEntry>();
    private FilterMode currentFilter = FilterMode.ALL;
    private boolean showActiveChallenges = false;
    private int totalChallengeCount = 0;
    private final List<ButtonBounds> challengeButtonBounds = new ArrayList<ButtonBounds>();
    private ButtonBounds hoveredButton = null;
    private int hoveredMouseX = 0;
    private int hoveredMouseY = 0;
    private String hoveredIconTooltip = null;
    private int hoveredIconX = 0;
    private int hoveredIconY = 0;

    public ChallengesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"challenges6t4.screen.title"));
        this.parent = parent;
        this.initializeEntries();
    }

    private void initializeEntries() {
        this.menuEntries.clear();
        this.totalChallengeCount = 0;
        if (this.showActiveChallenges) {
            this.addActiveChallenges();
        } else {
            switch (this.currentFilter.ordinal()) {
                case 0: {
                    this.addAllChallenges();
                    break;
                }
                case 1: {
                    this.addBlockColorChallenges();
                    break;
                }
                case 2: {
                    this.addWeatherChallenges();
                    break;
                }
                case 3: {
                    this.addSpecialMechanicsChallenges();
                    break;
                }
                case 4: {
                    this.addTeleportationChallenges();
                    break;
                }
                case 5: {
                    this.addEconomyChallenges();
                    break;
                }
                case 6: {
                    this.addMiscChallenges();
                }
            }
        }
    }

    private void addAllChallenges() {
        this.menuEntries.add(new MenuEntry("--= Block Color Challenges =--"));
        this.addChallengeIfRegistered("cant_touch_green");
        this.addChallengeIfRegistered("cant_touch_red");
        this.addChallengeIfRegistered("can_only_touch_green");
        this.addChallengeIfRegistered("cant_touch_anything");
        this.menuEntries.add(new MenuEntry("--= Weather/Environmental Challenges =--"));
        this.addChallengeIfRegistered("cant_breathe_air");
        this.addChallengeIfRegistered("chunk_swap");
        this.addChallengeIfRegistered("flame_on");
        this.addChallengeIfRegistered("freeze_on");
        this.menuEntries.add(new MenuEntry("--= Special Mechanics Challenges =--"));
        this.addChallengeIfRegistered("exploding_mobs");
        this.addChallengeIfRegistered("disappearing_blocks");
        this.menuEntries.add(new MenuEntry("--= Teleportation/Movement Challenges =--"));
        this.addChallengeIfRegistered("ender_pearl_on_damage");
        this.addChallengeIfRegistered("super_knockback");
        this.addChallengeIfRegistered("player_swap");
        this.addChallengeIfRegistered("faster_mobs");
        this.menuEntries.add(new MenuEntry("--= Economy/Purchase Challenges =--"));
        this.menuEntries.add(new MenuEntry("--= Misc Challenges =--"));
        this.addChallengeIfRegistered("no_exp");
        this.addChallengeIfRegistered("invisible_mobs");
    }

    private void addActiveChallenges() {
        this.menuEntries.add(new MenuEntry("--= Active Challenges =--"));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.isEnabled()) continue;
            this.menuEntries.add(new MenuEntry(challenge));
            ++this.totalChallengeCount;
        }
    }

    private void addBlockColorChallenges() {
        this.menuEntries.add(new MenuEntry("--= Block Color Challenges =--"));
        this.addChallengeIfRegistered("cant_touch_green");
        this.addChallengeIfRegistered("cant_touch_red");
        this.addChallengeIfRegistered("can_only_touch_green");
        this.addChallengeIfRegistered("cant_touch_anything");
    }

    private void addWeatherChallenges() {
        this.menuEntries.add(new MenuEntry("--= Weather/Environmental Challenges =--"));
        this.addChallengeIfRegistered("cant_breathe_air");
        this.addChallengeIfRegistered("chunk_swap");
        this.addChallengeIfRegistered("flame_on");
        this.addChallengeIfRegistered("freeze_on");
    }

    private void addSpecialMechanicsChallenges() {
        this.menuEntries.add(new MenuEntry("--= Special Mechanics Challenges =--"));
        this.addChallengeIfRegistered("exploding_mobs");
        this.addChallengeIfRegistered("disappearing_blocks");
    }

    private void addTeleportationChallenges() {
        this.menuEntries.add(new MenuEntry("--= Teleportation/Movement Challenges =--"));
        this.addChallengeIfRegistered("ender_pearl_on_damage");
        this.addChallengeIfRegistered("super_knockback");
        this.addChallengeIfRegistered("player_swap");
        this.addChallengeIfRegistered("faster_mobs");
    }

    private void addEconomyChallenges() {
        this.menuEntries.add(new MenuEntry("--= Economy/Purchase Challenges =--"));
    }

    private void addMiscChallenges() {
        this.menuEntries.add(new MenuEntry("--= Misc Challenges =--"));
        this.addChallengeIfRegistered("no_exp");
        this.addChallengeIfRegistered("invisible_mobs");
    }

    private void addChallengeIfRegistered(String challengeId) {
        Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
        if (challenge != null) {
            this.menuEntries.add(new MenuEntry(challenge));
            ++this.totalChallengeCount;
        }
    }

    private void refreshEntries() {
        this.scrollPosition = 0.0f;
        this.initializeEntries();
        this.method_25426();
    }

    private int getTotalContentHeight() {
        int y = 0;
        for (MenuEntry entry : this.menuEntries) {
            if (entry.isCategory) {
                y += 34;
                continue;
            }
            y += 38;
        }
        return y;
    }

    private int getMaxScroll() {
        int contentHeight = this.getTotalContentHeight();
        int visibleHeight = this.field_22790 - 70 - 32;
        return Math.max(0, contentHeight - visibleHeight);
    }

    protected void method_25426() {
        this.method_37067();
        this.challengeButtonBounds.clear();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Disable All"), button -> {
            for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                if (!challenge.isEnabled()) continue;
                challenge.setEnabled(false);
            }
            this.method_25426();
        }).method_46434(this.field_22789 - 100 - 8, 8, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))), button -> {
            ActiveChallengesOverlay.toggleNotifications();
            button.method_25355((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))));
        }).method_46434(8, 8, 140, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Filter: " + this.currentFilter.getDisplayName())), button -> {
            FilterMode[] modes = FilterMode.values();
            int currentIndex = this.currentFilter.ordinal();
            this.currentFilter = modes[(currentIndex + 1) % modes.length];
            button.method_25355((class_2561)class_2561.method_43470((String)("Filter: " + this.currentFilter.getDisplayName())));
            this.showActiveChallenges = false;
            this.refreshEntries();
        }).method_46434(8, 32, 120, 16).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Active Challenges"), button -> {
            boolean bl = this.showActiveChallenges = !this.showActiveChallenges;
            if (this.showActiveChallenges) {
                button.method_25355((class_2561)class_2561.method_43470((String)"All Challenges"));
            } else {
                button.method_25355((class_2561)class_2561.method_43470((String)"Active Challenges"));
            }
            this.refreshEntries();
        }).method_46434(this.field_22789 - 120 - 8, 32, 120, 16).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
        int y = 0;
        for (MenuEntry entry : this.menuEntries) {
            entry.virtualY = y;
            if (entry.isCategory) {
                y += 34;
                continue;
            }
            if (entry.challenge != null) {
                String label = entry.challenge.getName().getString() + " [" + (entry.challenge.isEnabled() ? "ON" : "OFF") + "]";
                int btnW = this.field_22789 - 200;
                int btnX = 80;
                entry.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)label), button -> {
                    entry.challenge.setEnabled(!entry.challenge.isEnabled());
                    String newLabel = entry.challenge.getName().getString() + " [" + (entry.challenge.isEnabled() ? "ON" : "OFF") + "]";
                    button.method_25355((class_2561)class_2561.method_43470((String)newLabel));
                }).method_46434(btnX, 0, btnW - 40, 28).method_46431();
                entry.showcaseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83c\udfa5"), button -> {
                    if (entry.challenge.hasShowcaseVideo()) {
                        this.openShowcaseVideo(entry.challenge);
                    }
                }).method_46434(43, 0, 25, 24).method_46431();
                if (entry.challenge.hasShowcaseVideo()) {
                    this.method_25429((class_364)entry.showcaseButton);
                }
                if (entry.challenge.hasOptions()) {
                    entry.optionsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Options"), button -> this.openOptionsScreen(entry.challenge)).method_46434(this.field_22789 - 110, 0, 70, 28).method_46431();
                }
            }
            y += 38;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition - (float)(verticalAmount * 20.0)), (float)0.0f, (float)maxScroll);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isDragging) {
            int maxScroll = this.getMaxScroll();
            int visibleHeight = this.field_22790 - 70 - 32;
            int contentHeight = this.getTotalContentHeight();
            float scrollAmount = (float)(deltaY * (double)maxScroll) / (float)(visibleHeight - Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight)));
            this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition + scrollAmount), (float)0.0f, (float)maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int scrollbarX = this.field_22789 - 6 - 4;
            int scrollbarY = 70;
            int scrollbarHeight = this.field_22790 - 70 - 32;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.isDragging = true;
                return true;
            }
        } else if (button == 1 && mouseX >= 8.0 && mouseX <= 128.0 && mouseY >= 32.0 && mouseY <= 48.0) {
            FilterMode[] modes = FilterMode.values();
            int currentIndex = this.currentFilter.ordinal();
            this.currentFilter = modes[(currentIndex - 1 + modes.length) % modes.length];
            this.showActiveChallenges = false;
            this.refreshEntries();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int tooltipY;
        int tooltipX;
        int tooltipHeight;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        int visibleTop = 75;
        int visibleBottom = this.field_22790 - 32;
        int visibleHeight = visibleBottom - visibleTop;
        int contentHeight = this.getTotalContentHeight();
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)this.scrollPosition, (float)0.0f, (float)maxScroll);
        this.challengeButtonBounds.clear();
        for (MenuEntry menuEntry : this.menuEntries) {
            boolean visible;
            int y = menuEntry.virtualY - (int)this.scrollPosition + 70;
            menuEntry.visible = visible = y + (menuEntry.isCategory ? 24 : 32) >= visibleTop && y <= visibleBottom;
            if (menuEntry.isCategory || menuEntry.challenge == null || !visible) continue;
            int buttonY = y + 5;
            if (menuEntry.showcaseButton != null && menuEntry.challenge.hasShowcaseVideo()) {
                menuEntry.showcaseButton.method_46419(buttonY);
                this.method_25429((class_364)menuEntry.showcaseButton);
            }
            if (menuEntry.toggleButton != null) {
                menuEntry.toggleButton.method_46419(buttonY);
                this.method_25429((class_364)menuEntry.toggleButton);
                this.challengeButtonBounds.add(new ButtonBounds(menuEntry.toggleButton.method_46426(), y, menuEntry.toggleButton.method_25368(), 32, menuEntry.challenge));
            }
            if (menuEntry.optionsButton == null) continue;
            menuEntry.optionsButton.method_46419(buttonY);
            this.method_25429((class_364)menuEntry.optionsButton);
        }
        int challengeIndex = 0;
        for (MenuEntry entry : this.menuEntries) {
            if (!entry.visible) continue;
            int y = entry.virtualY - (int)this.scrollPosition + 70;
            if (entry.isCategory) {
                int catWidth = this.field_22793.method_1727(entry.categoryName);
                context.method_51433(this.field_22793, entry.categoryName, (this.field_22789 - catWidth) / 2, y + 2, -22016, false);
                continue;
            }
            if (entry.challenge == null) continue;
            int bgColor = challengeIndex % 2 == 0 ? 0x15FFFFFF : 0xAFFFFFF;
            context.method_25294(0, y, this.field_22789, y + 32 + 6, bgColor);
            ++challengeIndex;
            if (entry.showcaseButton != null && entry.challenge.hasShowcaseVideo()) {
                entry.showcaseButton.method_25394(context, mouseX, mouseY, delta);
            }
            if (entry.toggleButton != null) {
                entry.toggleButton.method_25394(context, mouseX, mouseY, delta);
            }
            if (entry.optionsButton != null) {
                entry.optionsButton.method_25394(context, mouseX, mouseY, delta);
            }
            int iconX = this.field_22789 - 30;
            Objects.requireNonNull(this.field_22793);
            int iconY = y + (32 - 9) / 2;
            this.renderMultiplayerStatusIcon(context, entry.challenge, iconX, iconY);
            if (mouseX >= iconX && mouseX <= iconX + 16 && mouseY >= iconY) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY <= iconY + 9) {
                    this.hoveredIconTooltip = entry.challenge.getMultiplayerStatus().getDisplayText();
                    this.hoveredIconX = mouseX;
                    this.hoveredIconY = mouseY;
                }
            }
            if (entry.showcaseButton == null || !entry.challenge.hasShowcaseVideo()) continue;
            int showcaseX = entry.showcaseButton.method_46426();
            int showcaseY = entry.showcaseButton.method_46427();
            if (mouseX < showcaseX || mouseX > showcaseX + entry.showcaseButton.method_25368() || mouseY < showcaseY || mouseY > showcaseY + entry.showcaseButton.method_25364()) continue;
            this.hoveredIconTooltip = "Watch Showcase Video";
            this.hoveredIconX = mouseX;
            this.hoveredIconY = mouseY;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (contentHeight > visibleHeight) {
            int n = Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight));
            int scrollbarY = 70 + (int)(this.scrollPosition / (float)maxScroll * (float)(visibleHeight - n));
            int scrollbarX = this.field_22789 - 6 - 4;
            context.method_25294(scrollbarX, 70, scrollbarX + 6, this.field_22790 - 32, -14540254);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + n, -5592406);
        }
        this.hoveredButton = null;
        for (ButtonBounds bounds : this.challengeButtonBounds) {
            if (!bounds.isHovered(mouseX, mouseY)) continue;
            this.hoveredButton = bounds;
            this.hoveredMouseX = mouseX;
            this.hoveredMouseY = mouseY;
            break;
        }
        if (this.hoveredButton != null) {
            List list = this.field_22793.method_1728((class_5348)this.hoveredButton.challenge.getDescription(), 250);
            int tooltipWidth = 0;
            for (class_5481 line : list) {
                int lineWidth = this.field_22793.method_30880(line);
                if (lineWidth <= tooltipWidth) continue;
                tooltipWidth = lineWidth;
            }
            int n = list.size();
            Objects.requireNonNull(this.field_22793);
            tooltipHeight = n * (9 + 2);
            tooltipX = this.hoveredMouseX + 12;
            tooltipY = this.hoveredMouseY + 12;
            if (tooltipX + tooltipWidth + 8 > this.field_22789) {
                tooltipX = this.hoveredMouseX - tooltipWidth - 12;
            }
            if (tooltipY + tooltipHeight + 8 > this.field_22790) {
                tooltipY = this.hoveredMouseY - tooltipHeight - 12;
            }
            if (tooltipX < 8) {
                tooltipX = 8;
            }
            if (tooltipY < 8) {
                tooltipY = 8;
            }
            context.method_25294(tooltipX - 4, tooltipY - 4, tooltipX + tooltipWidth + 8, tooltipY + tooltipHeight + 4, -267382768);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY - 4, -5592406);
            context.method_25294(tooltipX - 5, tooltipY + tooltipHeight + 4, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX - 4, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX + tooltipWidth + 8, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            int y = tooltipY;
            for (class_5481 line : list) {
                context.method_35720(this.field_22793, line, tooltipX, y, -1);
                Objects.requireNonNull(this.field_22793);
                y += 9 + 2;
            }
        }
        if (this.hoveredIconTooltip != null) {
            String string = this.hoveredIconTooltip;
            int tooltipWidth = this.field_22793.method_1727(string);
            Objects.requireNonNull(this.field_22793);
            tooltipHeight = 9 + 8;
            tooltipX = this.hoveredIconX + 12;
            tooltipY = this.hoveredIconY + 12;
            if (tooltipX + tooltipWidth + 8 > this.field_22789) {
                tooltipX = this.hoveredIconX - tooltipWidth - 12;
            }
            if (tooltipY + tooltipHeight + 8 > this.field_22790) {
                tooltipY = this.hoveredIconY - tooltipHeight - 12;
            }
            if (tooltipX < 8) {
                tooltipX = 8;
            }
            if (tooltipY < 8) {
                tooltipY = 8;
            }
            context.method_25294(tooltipX - 4, tooltipY - 4, tooltipX + tooltipWidth + 8, tooltipY + tooltipHeight + 4, -267382768);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY - 4, -5592406);
            context.method_25294(tooltipX - 5, tooltipY + tooltipHeight + 4, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX - 5, tooltipY - 5, tooltipX - 4, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25294(tooltipX + tooltipWidth + 8, tooltipY - 5, tooltipX + tooltipWidth + 9, tooltipY + tooltipHeight + 5, -5592406);
            context.method_25303(this.field_22793, string, tooltipX, tooltipY, -1);
        }
        this.hoveredIconTooltip = null;
        int n = this.field_22793.method_1727("Challenges Menu");
        int titleX = this.field_22789 / 2 - n / 2;
        int titleY = 20;
        Objects.requireNonNull(this.field_22793);
        context.method_25294(titleX - 8, titleY - 4, titleX + n + 8, titleY + 9 + 4, Integer.MIN_VALUE);
        context.method_51433(this.field_22793, "Challenges Menu", titleX, titleY, -1118482, false);
        String counterText = "Total: " + this.totalChallengeCount + " challenges";
        int counterWidth = this.field_22793.method_1727(counterText);
        int counterX = this.field_22789 / 2 - counterWidth / 2;
        Objects.requireNonNull(this.field_22793);
        int counterY = titleY + 9 + 8;
        context.method_51433(this.field_22793, counterText, counterX, counterY, -3355444, false);
    }

    private void openOptionsScreen(Challenge challenge) {
        try {
            String challengeClassName = challenge.getClass().getSimpleName();
            String optionsScreenName = challengeClassName.endsWith("Challenge") ? challengeClassName.substring(0, challengeClassName.length() - "Challenge".length()) + "OptionsScreen" : challengeClassName + "OptionsScreen";
            String optionsScreenClassName = "me.angel.challenges6t4.client.screen." + optionsScreenName;
            Class<?> optionsScreenClass = Class.forName(optionsScreenClassName);
            Class<?> challengeClass = challenge.getClass();
            Constructor<?> constructor = optionsScreenClass.getConstructor(class_437.class, challengeClass);
            class_437 optionsScreen = (class_437)constructor.newInstance(new Object[]{this, challenge});
            if (optionsScreen != null) {
                this.field_22787.method_1507(optionsScreen);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to open options screen for challenge: " + challenge.getId());
            e.printStackTrace();
        }
    }

    private void openShowcaseVideo(Challenge challenge) {
        try {
            String showcaseUrl = challenge.getShowcaseVideoUrl();
            if (showcaseUrl != null && !showcaseUrl.isEmpty()) {
                class_156.method_668().method_670(showcaseUrl);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to open showcase video for challenge: " + challenge.getId());
            e.printStackTrace();
        }
    }

    private void renderMultiplayerStatusIcon(class_332 context, Challenge challenge, int x, int y) {
        String emoji = switch (challenge.getMultiplayerStatus()) {
            default -> throw new MatchException(null, null);
            case Challenge.MultiplayerStatus.SINGLE_PLAYER_ONLY -> "\ud83e\uddcd";
            case Challenge.MultiplayerStatus.MULTIPLAYER_COMPATIBLE -> "\ud83d\udc91";
            case Challenge.MultiplayerStatus.MULTIPLAYER_ONLY -> "\ud83d\udc65";
            case Challenge.MultiplayerStatus.UNTESTED_MULTIPLAYER -> "\u2757";
            case Challenge.MultiplayerStatus.EXPERIMENTAL -> "\u26a1";
        };
        int color = switch (challenge.getMultiplayerStatus()) {
            default -> throw new MatchException(null, null);
            case Challenge.MultiplayerStatus.SINGLE_PLAYER_ONLY -> -21931;
            case Challenge.MultiplayerStatus.MULTIPLAYER_COMPATIBLE -> -11141291;
            case Challenge.MultiplayerStatus.MULTIPLAYER_ONLY -> -11184641;
            case Challenge.MultiplayerStatus.UNTESTED_MULTIPLAYER -> -171;
            case Challenge.MultiplayerStatus.EXPERIMENTAL -> -43691;
        };
        context.method_51433(this.field_22793, emoji, x, y, color, false);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum FilterMode {
        ALL("All Challenges"),
        BLOCK_COLOR("Block Color"),
        WEATHER("Weather/Environmental"),
        SPECIAL_MECHANICS("Special Mechanics"),
        TELEPORTATION("Teleportation/Movement"),
        ECONOMY("Economy/Purchase"),
        MISC("Misc");

        private final String displayName;

        private FilterMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ButtonBounds {
        int x;
        int y;
        int w;
        int h;
        Challenge challenge;

        ButtonBounds(int x, int y, int w, int h, Challenge challenge) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.challenge = challenge;
        }

        boolean isHovered(int mx, int my) {
            return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class MenuEntry {
        final Challenge challenge;
        final boolean isCategory;
        final String categoryName;
        int virtualY;
        class_4185 toggleButton;
        class_4185 optionsButton;
        class_4185 showcaseButton;
        boolean visible;

        MenuEntry(String categoryName) {
            this.categoryName = categoryName;
            this.isCategory = true;
            this.challenge = null;
            this.visible = false;
        }

        MenuEntry(Challenge challenge) {
            this.challenge = challenge;
            this.isCategory = false;
            this.categoryName = null;
            this.visible = false;
        }
    }
}

